/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.init;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adhooks.Main;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.endertech.minecraft.mods.adhooks.items.Launcher;
import com.endertech.minecraft.mods.adhooks.items.Properties;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public enum HookType implements IForgeEnum
{
    PROTOTYPE(new Properties()),
    PUDGE(new Properties().launcher(300, 0.7f, 1.0f).hook(10.0f, 0.0f).rope(32, 0.0f, 3.0f, -4259840)),
    SPEAR(new Properties().launcher(180, 0.5f, 1.0f).hook(5.0f, 2.0f).rope(64, 0.6f, 4.0f, -1090519040)),
    WEB(new Properties().launcher(240, 0.8f, 1.0f).hook(2.0f, 0.0f).rope(76, 0.95f, 6.0f, -1));

    final Properties props;
    public final Hook hook;
    public final Rope rope;
    public final Launcher launcher;

    private HookType(Properties props) {
        props.hookType = this;
        this.props = props;
        Main mod = Main.instance;
        Path configDir = mod.getConfig().getConfigDir();
        UnitConfig hookConfig = new UnitConfig(configDir, "hooks", this.func_176610_l());
        this.hook = new Hook(mod, hookConfig, this, props.hookStrength, props.hookDamage, props.hookStrength);
        UnitConfig launcherConfig = new UnitConfig(configDir, "launchers", this.func_176610_l());
        this.rope = new Rope((ForgeConfig)launcherConfig, props.ropeMaxLength, props.ropeWidth, props.ropeElasticity, ColorARGB.from((int)props.ropeColorARGB));
        this.launcher = new Launcher(mod, this.func_176610_l(), launcherConfig, this, props.durability, props.reelingSpeed, props.boostStrength);
        hookConfig.save();
        launcherConfig.save();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            for (HookType type : HookType.values()) {
                Main.instance.getConnection().sendToPlayer((IMessage)type.props.readValues(), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public static void remapMissingItems(RegistryEvent.MissingMappings<Item> event) {
        HashMap<String, Hook> hookMap = new HashMap<String, Hook>();
        HashMap<String, Launcher> launcherMap = new HashMap<String, Launcher>();
        for (HookType element : HookType.values()) {
            hookMap.put("hook" + element.name().toLowerCase(Locale.ROOT), element.hook);
            launcherMap.put("hooklauncher" + element.name().toLowerCase(Locale.ROOT), element.launcher);
        }
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            String oldName = mapping.key.func_110623_a().toLowerCase(Locale.ROOT);
            Hook hook = (Hook)((Object)hookMap.get(oldName));
            Launcher launcher = (Launcher)((Object)launcherMap.get(oldName));
            if (hook != null) {
                mapping.remap((IForgeRegistryEntry)hook);
            }
            if (launcher == null) continue;
            mapping.remap((IForgeRegistryEntry)launcher);
        }
    }

    public String func_176610_l() {
        return this.getLowerCase(this.name());
    }
}

